--[[---------------------------------------------------------------------------
	Chocolatier Two Quests
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

QuestStringTable("quests/quest_strings.xml")


-- TUTORIAL (RANK0) LEVEL QUESTS -----------------------------------------------------

DefineQuest
{
	name = "tutor00b",
	starter = "sf_tutor",
	denial = {MarkComplete ("tutor00b"), OfferQuest("nototutor"),},
	forceOffer = true,
	accept = "yesplease",
	reject = "imgood",
	followUp = "tutor01",
}

DefineQuest
{
	name = "tutor01",
	requirements = { RequireQuestIncomplete("tutorend")},
	starter = "sf_tutor",
	forceAccept = true,
	gifts = { AwardItem("cacao",50), AwardItem("sugar",50), ShowLedger("inventory"),},
	followUp = "tutor02",
}

DefineQuest
{
	name = "tutor02",
	starter = "sf_tutor",
	forceAccept = true,
--	gifts = { ShowLedger("messages")},	
	ender = "sf_factorykeep",
	followUp = "tutor03",
}

DefineQuest
{
	name = "tutor03",
	starter = "sf_factorykeep",
	forceAccept = true,
	goals = { RequireItem("b_01", 10),},
	rewards = {ShowLedger("inventory")},
	followUp = "tutor04",
}

DefineQuest
{
	name = "tutor04",
	starter = "sf_factorykeep",
	forceAccept = true,	
--	gifts = { ShowLedger("messages")},
	summary = "backtoalex",
	ender = "sf_tutor",
	followUp = "tutor05",
}

DefineQuest
{
	name = "tutor05",
	starter = "sf_tutor",
	forceAccept = true,	
--	gifts = { ShowLedger("messages")},
	ender = "sf_shopkeep",
	followUp = "tutor06",
}

DefineQuest
{
	name = "tutor06",
	requirements = {RequireItem("b_01", 1)},
	starter = "sf_shopkeep",
	goals = { MinMoney(10)},
	forceAccept = true,
	ender = "sf_shopkeep",
	rewards = {SetHappy("sf_shopkeep")},
	followUp = "tutor07",
}

DefineQuest
{
	name = "tutor07",
	starter = "sf_shopkeep",
	summary = "backtoalex",
	ender = "sf_tutor",
	forceAccept = true,
	followUp = "tutor08",
}

DefineQuest
{
	name = "tutor08",
	starter = "sf_tutor",
	ender = "sf_marketkeep",
	forceAccept = true,
	followUp = "tutor09",
}

DefineQuest
{
	name = "tutor09",
	starter = "sf_marketkeep",
	goals = { RequireItem ("sugar",50)},
	rewards = {SetHappy("sf_marketkeep")},
	forceAccept = true,
	followUp = "tutor10",
}

DefineQuest
{
	name = "tutor10",
	starter = "sf_marketkeep",
	summary = "backtoalex",
	ender = "sf_tutor",
	forceAccept = true,
	followUp = "tutor11",
}

DefineQuest
{
	name = "tutor11",
	starter = "sf_tutor",
	gifts = { AwardMoney(10000), EnablePort("sanjose")},
	goals = {RequireItem("cacao", 100)},
	ender = "sj_marketkeep",
	rewards = {SetHappy("sj_marketkeep")},
	forceAccept = true,
	followUp = "tutor12",
}

DefineQuest
{
	name = "tutor12",
	starter = "sj_marketkeep",
	ender = "sf_tutor",
	rewards = {ShowLedger("factories")},
	forceAccept = true,
	followUp = "tutor13",
}

DefineQuest
{
	name = "tutor13",
	starter = "sf_tutor",
--	rewards = {ShowLedger("inventory")},
	forceAccept = true,
	followUp = "tutor14",
}

DefineQuest
{
	name = "tutor14",
	starter = "sf_tutor",
	gifts = {EnablePort("newyork"),},
	ender = "ny_librarykeep",
	forceAccept = true,
	followUp = "tutor15",
}

DefineQuest
{
	name = "tutor15",
	starter = "ny_librarykeep",
	goals = {RequireItem("b_01", 10)},
	ender = "ny_librarykeep",
	forceAccept = true,
	rewards = {AwardMoney(5000), AwardItem("b_01", -10), AwardRecipe("b_02"), ShowRecipes(),},
	followUp = "tutor16a",
}

DefineQuest
{
	name = "tutor16a",
	starter = "ny_librarykeep",	
	ender = "ny_factorykeep",
	forceAccept = true,
	followUp = "tutor16b",
}


DefineQuest
{
	name = "tutor16b",
	starter = "ny_factorykeep",
--	gifts = {ShowDialog("tutor16b_extra01")},
	ender = "sf_tutor",
	rewards = {ShowLedger("inventory")},
	forceAccept = true,
	followUp = "tutor17",
}

DefineQuest
{
	name = "tutor17",
	starter = "sf_tutor",
	ender= "sf_factorykeep",
	requirements = {RequireRecipe("b_02")},
	forceAccept = true,
	gifts = {ShowLedger("inventory")},
	goals = {RequireItem("sugar", 15), RequireItem("cacao", 30),},
	followUp = "tutor18",
}

DefineQuest
{
	name = "tutor18",
	starter = "sf_factorykeep",
	requirements = {RequireItem("sugar", 15), RequireItem("cacao", 30),},
--	gifts = {ShowLedger("messages"), ShowDialog("tutor18_extra01")},
	ender = "sf_tutor",
	forceAccept = true,
	goals = {RequireItem("b_02", 15)},
	rewards = {SetVar("tutorcomplete", 1), SetVar("HaggleBonus", 4), OfferQuest("tutorend"),},
}

DefineQuest
{
	name = "nototutor",
	requirements = {RequireQuestIncomplete("tutor01")},
	starter = "sf_tutor",
	forceAccept = true,
	rewards = {SetVar("tutorcomplete", 1), SetVar("HaggleBonus", 2), AwardMoney(5000), AwardRecipe("b_02"), EnablePort("newyork"), EnablePort("sanjose"), AwardTimeWarp(4), OfferQuest("tutorend"),},
}

DefineQuest
{
	name = "tutorend",
	requirements = { VarEquals ("tutorcomplete", 1)},
	starter = "sf_tutor",
	forceAccept = true,
	gifts = {IncrementVar("bcsign"), AwardRank(1), AwardLogo(), ShowDialog("tutorend_extra01"), AwardMoney(7500), EnablePort("buenosaires"), EnablePort("cayenne"), AwardRecipe("b_03"), AwardRecipe("b_04"), ShowRecipes(), ShowDialog("tutorend_extra02"), ShowLedger("factories"), AwardRefreshPort()},
}

-- NOVICE (RANK1) LEVEL QUESTS -----------------------------------------------------

DefineQuest
{
	name = "novice_teaser_01",
	requirements = { MinRank(1), MinWeek(18), MaxWeek(35), RequireNoMedal("lab")},
	starter = "traveler02",
	forceOffer = true,
	forceAccept = true,
}

DefineQuest
{
	name = "novice_hint01",
	requirements = {MinRank(1)},
	starter = "traveler03",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_hint02",
	requirements = {MinRank(1)},
	starter = "traveler05",
	forceAccept = true,
}


DefineQuest
{
	name = "novice_story01",
	requirements = {MinRank(1), MaxRank(1)},
	starter = "sf_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story02",
	requirements = {MinRank(1), RequireQuest("novice_story08") },
	starter = "sf_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story03",
	requirements = {MinRank(1)},
	starter = "cay_hotelkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story04",
	requirements = {MinRank(1)},
	starter = "cay_farmkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story05",
	requirements = {MinRank(1), RequireQuestIncomplete("sj_shopown_02")},
	starter = "sj_shopkeep",
	forceAccept = true,
	rewards = {DelayQuest("novice_story05b",20)},
}

DefineQuest
{
	name = "novice_story05b",
	requirements = {MinRank(1), RequireTotalRecipesKnown(7), RequireQuest("novice_story05"), RequireQuestIncomplete("sj_shopown_02")},
	starter = "sj_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story06",
	requirements = {MinRank(1), MaxRank(2)},
	starter = "sj_farmkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story07",
	requirements = {MinRank(1), MaxRank(2)},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14", "traveler15", "traveler16", "talker" },
	forceAccept = true,
}


DefineQuest
{
	name = "novice_story08",
	requirements = {MinRank(1), VarMoreThan("bcsign", 0)},
	starter = "sf_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story09",
	requirements = {MinRank(1)},
	starter = "cay_isleskeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story09b",
	requirements = {MinRank(1), MinWeek(25), RequireQuestIncomplete("novice07"),},
	starter = "cay_isleskeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story10",
	requirements = {MinRank(1)},
	starter = "ny_librarykeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story11",
	requirements = {MinRank(1), MaxRank(2)},
	starter = "ny_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "novice_story12",
	requirements = {MinRank(1), MaxRank(2)},
	starter = "traveler07",
	forceAccept = true,
}

DefineQuest
{
	name = "novice01_nudge",
	requirements = { MinRank(1), MaxRank(2), RequireQuestIncomplete("novice01"),},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14",},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("novice01_nudge", 22),},
}

DefineQuest
{
	name = "novice01",
	requirements = { MinRank(1)},
	starter = "sf_tutor",
	accept = "iwill",
	gifts = {AwardRecipe("b_05"), ShowRecipes()},
	goals = {RequireItem("b_05", 20)},
	ender = "cay_barkeep",
	rewards = {DelayQuest("novice10", 14), IncrementVar("ncomplete"), AwardItem("b_05", -20), AwardMoney(15000), AwardRecipe("b_06"), ShowRecipes(),},
}


DefineQuest
{
	name = "novice02_nudge",
	requirements = { MinRank(1), MaxRank(2), RequireQuestIncomplete("novice02"),},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14"},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("novice02_nudge", 19),},
}

DefineQuest
{
	name = "novice02",
	requirements = {MinRank(1)},
	starter = "sf_tutor",
	accept = "indeed",
	reject = "notrightnow",
	ender = "ba_avenidakeep",
	followUp = "novice03",
}

DefineQuest
{
	name = "novice03",
	requirements = { MinRank(1)},
	starter = "ba_avenidakeep",
	accept = "iwill",
	gifts = {AwardRecipe("b_08"), ShowRecipes(), ShowDialog("novice03_extratext01"),},
	goals = {RequireItem("b_08", 35)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_08", -35), AwardMoney(6500)},
}

DefineQuest
{
	name = "novice04",
	requirements = { MinRank(1), MinWeek(18), MinMoney(12500)},
	starter = "traveler04",
	accept = "youbet",
	rewards = {IncrementVar("ncomplete"), AwardMoney(-9500), AwardRecipe("b_07"), ShowRecipes()},
}

DefineQuest
{
	name = "novice04b",
	requirements = {RequireQuest("novice04"), MinWeek(590)},
	starter = "traveler04",
	forceAccept = true,
	rewards = {AwardMessage("novice04_msgb")},
}

DefineQuest
{
	name = "novice05",
	requirements = {MinRank(1), MinWeek(34)},
	starter = "traveler02",
	ender = "ny_barkeep",
--	forceOffer = true,
	accept = "ofcourse",
	reject = "nothanks",
	gifts = {ShowDialog("novice05_extratext01"),},
	goals = {RequireItem("pecan", 20)},
	rewards = {IncrementVar("ncomplete"), AwardMessage("novice05_complete_msg"), AwardItem("pecan", -20), AwardRecipe("b_11"), ShowRecipes(),},
}


DefineQuest
{
	name = "novice06",
	requirements = {MinRank(1), RequireQuest("novice05"), RequireItem("b_11", 48) },
	starter = "ny_barkeep",
	accept = "certainly",
	reject = "nothanks",
	denial ={MarkComplete("novice06")},
	goals = {RequireItem("b_11", 48)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_11", -48), AwardMoney(125000)},
}

DefineQuest
{
	name = "novice07",
	requirements = {MinRank(1), RequireRecipe("b_03")},
	starter = "sf_tutor",
	ender = "cay_isleskeep",
	accept = "certainly",
	reject = "nothanks",
	gifts = {AwardMoney(12500)},
	goals = {RequireItem("b_03", 30)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_03", -30), AwardRecipe("b_09"), ShowRecipes(), ShowDialog("novice07_extratext01"),},
}


DefineQuest
{
	name = "novice08",
	requirements = {MinRank(1), MinMoney(22000)},
	starter = "traveler05",
	accept = "takeit",
	reject = "nothanks",
	rewards = {IncrementVar("ncomplete"), AwardMoney(-16500), AwardRecipe("b_10"), ShowRecipes()},
}


DefineQuest
{
	name = "novice09",
	requirements = {MinRank(1), RequireRecipe("b_04")},
	starter = "ba_teatrokeep",
	accept = "sure",
	reject = "noimbusy",
	denial = {ShowDialog("novice09_extratext01"), MarkComplete("novice09")},
	goals = {RequireItem("b_04", 200)},
	rewards = { AwardMoney(100000), AwardItem("b_04", -200) },
}

DefineQuest
{
	name = "novice10",
	requirements = { MinRank(1), RequireQuest("novice01")},
	starter = "cay_barkeep",
	accept = "indeed",
	hintweeks = 17,
	goals = {RequireItem("b_05", 40), RequireItem("b_06", 40)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_05", -40), AwardItem("b_06", -40), AwardMoney(200000)},
	denial = {MarkComplete("novice10")},
}

	
DefineQuest
{
	name = "novice11",
	requirements = {MinRank(1), RequireQuest("novice04b"), RequireRecipe("b_07")},
	starter = "ba_obeliscokeep",
	gifts = {AwardMoney(60000)},
	goals = {RequireItem("b_07", 85)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_07", -85)},
	denial = {MarkComplete("novice11")},
}

DefineQuest
{
	name = "novice12",
	requirements = { MinRank(1), RequireRecipe("b_08")},
	starter = "ny_barkeep",
	goals = {RequireItem("b_08", 24)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_08", -24), AwardMoney(20000)},
	denial = {ShowDialog("notonovice12"), MarkComplete("novice12")},
}


DefineQuest
{
	name = "novice13",
	requirements = { MinRank(1), RequireRecipe("b_09")},
	starter = "traveler03",
	accept = "sure",
	gifts = {ShowDialog("novice13_extra01"), AwardItem("raspberry", 500)},
	goals = {RequireWeeks (7), RequireItem("b_09", 100)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_09", -100)},
	denial = {MarkComplete("novice13")},
}

DefineQuest
{
	name = "novice14",
	requirements = { MinRank(1), RequireRecipe("b_02")},
	starter = "sj_otherkeep",
	accept = "soundsgood",
	reject = "nothanks",
	goals = {RequireItem("b_02", 29)},
	rewards = {AwardItem("cacao", 500), IncrementVar("ncomplete"), AwardItem("b_02", -29) },
	denial = {MarkComplete("novice14")},
}

DefineQuest
{
	name = "novice15",
	requirements = { MinRank(1)},
	starter = "ny_librarykeep",
	accept = "absolutely",
	goals = {RequireItem("b_02", 100)},
	rewards = {IncrementVar("ncomplete"), AwardItem("b_02", -100), AwardMoney(65000)},
	denial = {MarkComplete("novice15")},
}

DefineQuest
{
	name = "rank2coming_hint",
	requirements = {MinRank(1), MaxRank(1), MinWeek(26), RequireTotalRecipesKnown(7),},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14",},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("rank2coming_hint", 52),},
}
	
DefineQuest
{
	name = "noviceend",
	requirements = { VarEquals("tutorcomplete",1), RequirePort("amazon")},
	starter = "announcer",
	ender = "sf_tutor",
	summary = "backtoalex",
	forceAccept = true,
	forceOffer = true,
	rewards = {IncrementVar("bcsign"), EnablePort("paris"), EnablePort("casablanca"), EnablePort("abidjan"), AwardRank(2), AwardRecipe("i_01"), AwardRecipe("i_02"), AwardRecipe("i_04"), ShowRecipes(), ShowDialog("noviceend_extratext01"), DelayQuest("lab01", 3), DelayQuest("lab01_nudge", 4)},
}


-- ENTREPENEUR (RANK2) LEVEL QUESTS -----------------------------------------------------

DefineQuest
{
	name = "rank2_01",
	requirements = {MinRank(2), RequireRecipe("i_04")},
	starter = "pa_moulinkeep",
	ender = "cay_hotelkeep",
	accept = "sure",
	gifts = {ShowDialog("rank2_01_extra01")},
	reject = "nothanks",
	goals = {RequireItem("i_04", 28)},
	rewards = {IncrementVar("rank2complete"), IncrementVar("knows_evangeline"), AwardItem("i_04", -28), AwardRecipe("i_05"), ShowRecipes()},
}

DefineQuest
{
	name = "rank2_02",
	requirements = {MinRank(2)},
	starter = {"pa_towerkeep", "pa_notredamekeep"},
	ender = "pa_cafekeep",
	accept = "ofcourse",
	goals = {RequireItem("i_02", 136)},
	rewards = {IncrementVar("rank2complete"),  AwardItem("i_02", -136),  AwardRecipe("i_07"), AwardRecipe("i_08"), ShowRecipes()},
}

DefineQuest
{
	name = "rank2_03",
	requirements = {MinRank(2)},
	starter = "ab_villagekeep",
	accept = "ofcourse",
	gifts = { AwardRecipe("i_10"), ShowRecipes()},
	goals = {RequireItem("i_10", 25)},
	rewards = {IncrementVar("rank2complete"),  AwardItem("i_10", -25), AwardMoney(10000)},
}

DefineQuest
{
	name = "sauce_open",
	requirements = {MinRank(2), VarMoreThan("InventedRecipes",0)},
	starter = "announcer",
	summary = "backtoalex",
	ender = "sf_tutor",
	priority = true,
	forceAccept = true,
	rewards = {DelayQuest("rank2_mid", 13), ShowDialog("sauce_open_extra01"), IncrementVar("yessauce"), AwardRecipe("s_01"), AwardRecipe("s_02"), ShowRecipes()},
}

DefineQuest
{
	name = "rank2_10",
	requirements = {MinRank(2), RequireRecipe("s_02")},
	starter = "traveler07",
	ender = "ba_shopkeep",
	accept = "ofcourse",
	goals = {RequireItem("s_02", 48)},
	followUp = "rank2_11",
}

DefineQuest
{
	name = "rank2_11",
	requirements = {MinRank(2), RequireItem("s_02", 12)},
	starter = "ba_shopkeep",
	gifts = {ShowDialog("rank2_11_extra01"), AwardItem("s_02", - 48), AwardRecipe("s_10"), ShowRecipes(),},
	ender = "traveler07",
	goals = {RequireWeeks(4), RequireItem("s_10", 1)},
	rewards = {IncrementVar("rank2complete"), AwardItem("s_10", -1)},
}

DefineQuest
{
	name = "rank2_12_nudge",
	requirements = {MinRank(2), RequireRecipe("s_02"), RequireRecipeUnknown("s_11")},
	starter = {"ba_shopkeep", "ny_shopkeep", "sf_shopkeep", "pa_shopkeep", "sj_shopkeep"},
	accept = "iwill",
	reject = "notrightnow",
	ender = "cay_farmkeep",
	rewards = {OfferQuest("rank2_12")},
	denial = {DelayQuest("rank2_12_nudge", 45)},
--	repeatable = true,
}

DefineQuest
{
	name = "rank2_12",
	requirements = {MinRank(2), RequireRecipe("s_02")},
	starter = "cay_farmkeep",
	ender = "cay_hotelkeep",
	accept = "ofcourse",
	gifts = {AwardRecipe("s_11"), ShowRecipes(), ShowDialog("rank2_12_extra01"),},
	goals = {RequireItem("s_11", 40)},
	rewards = {IncrementVar("rank2complete"), IncrementVar("plotpoints"), AwardItem("s_11", -40)},
}


DefineQuest
{
	name = "rank2_13",
	requirements = {MinRank(2), RequireRecipe("s_02")},
	starter = "traveler14",
	ender = "pa_towerkeep",
	accept = "yesiwill",
	reject = "nothanks",
	goals = {RequireItem("s_02", 200)},
	rewards = {IncrementVar("rank2complete"), AwardItem("s_02", -200), AwardMoney(100000), AwardRecipe("s_03"), AwardRecipe("s_04"), ShowRecipes(),},
}

DefineQuest
{
	name = "rank2_mid",
	requirements = { MinRank(2), RequireTotalRecipesKnown(22), RequireNotFirstPeek()},
	starter = "announcer",
	ender = "sf_tutor",
	summary = "backtoalex",
	forceAccept = true,
--	forceOffer = true,
	priority = true,
	rewards = {IncrementVar("bcsign"), IncrementVar("plotpoints"), EnablePort("moscow"), EnablePort("cairo"), EnablePort("mahajanga")},
	followUp = "rank2_21",
}

DefineQuest
{
	name = "rank2_21",
	requirements = { MinRank(2), RequireQuest("rank2_mid"),},
	starter = "sf_tutor",
	ender = "ca_shopkeep",
	forceAccept = true,
	rewards = {IncrementVar("ca_shopown"), SetHappy("ca_shopkeep"), ShowDialog("rank2_21_extra01"), AwardRecipe("p_01"), AwardRecipe("p_02"), AwardRecipe("p_03"), ShowRecipes()},
	followUp = "rank2_22",
}

DefineQuest
{
	name = "rank2_22",
	requirements = { MinRank(2), RequireQuest("rank2_mid"),},
	starter = "ca_shopkeep",
	ender = "ca_bridgekeep",
	accept = "certainly",
	goals = {RequireItem("p_01", 50)},
	rewards = {IncrementVar("ca_shopown"), AwardItem("p_01", -50)},
	followUp = "rank2_23",
}

DefineQuest
{
	name = "rank2_23",
	requirements = { MinRank(2), RequireQuest("rank2_mid"),},
	starter = "ca_bridgekeep",
	ender = "ma_farmkeep",
	accept = "absolutely",
	gifts = {ShowDialog("rank2_23_extra01")},
	goals = {RequireItem("p_02", 44)},
	rewards = {AwardItem("p_02", -44), AwardRecipe ("s_12"), ShowRecipes()},
}

DefineQuest
{
	name = "rank2_30",
	requirements = { MinRank(2), MinWeek(36), RequireRecipeUnknown("i_09")},
	starter = "traveler04",
	ender = "cay_isleskeep",
	accept = "illdoit",
	gifts = {AwardRecipe("i_09"), ShowRecipes(),},
	goals ={RequireItem("i_09", 48)},
	rewards = {IncrementVar("plotpoints"), IncrementVar("ncomplete"), AwardItem("i_09", -48)},
}

DefineQuest
{
	name = "rank2_101",
	requirements = { MinRank(2), RequireQuest("ca_shopown_07"),},
	starter = "bom_other2keep",
	forceAccept = true,
	gifts = {AwardRecipe("p_09"), ShowRecipes()},
}


DefineQuest
{
	name = "rank2_i_11_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipeUnknown("i_11"),},
	starter = "traveler16",
	gifts = {ShowDialog("rank2_i_11_nudge_extra")},
	ender = "sj_farmkeep",
	denial = {DelayQuest("rank2_i_11_nudge", 20)},
	repeatable = true,
	rewards = {AwardRecipe("i_11"), ShowRecipes()},
}

DefineQuest
{
	name = "rank2_i_12_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipeUnknown("i_12"),},
	starter = "cay_marketkeep",
	accept = "yesiam",
	reject = "notrightnow",
	rewards = {AwardRecipe("i_12"), ShowRecipes(), ShowDialog ("rank2_i_11_nudge_extra01"),},
	denial = {DelayQuest("rank2_i_12_nudge", 20)},
}

DefineQuest
{
	name = "rank2end_nudge",
	requirements = {MinRank(2), RequireQuest("rank2_mid"), RequireTotalRecipesKnown(29), VarLessThan("InventedRecipes",6)},	
	starter = "announcer",
	forceAccept = true,
	priority = true,
	repeatable = true,
	rewards = {DelayQuest("rank2end_nudge", 50)},
}

DefineQuest
{
	name = "rank2end",
	requirements = {MinRank(2), RequireQuest("rank2_mid"), RequireTotalRecipesKnown(30), VarMoreThan("InventedRecipes",5)},	
	starter = "announcer",
	gifts = {IncrementVar("bcsign"), AwardRank(3), SetAngry("sf_bchqkeep"),},
	ender = "sf_bchqkeep",
	summary = "backtoalex",
	forceAccept = true,
	forceOffer = true,
	rewards = {ShowDialog("rank2end_extra01"), EnablePort("shanghai"), EnablePort("manila")},
}

DefineQuest
{
	name = "rank2end_b",
	requirements = {MinRank(3)},	
	starter = "traveler05",
	ender = "sf_tutor",
	forceAccept = true,
	forceOffer = true,
	gifts = {EnablePort("jakarta")},
	rewards = {ShowDialog("rank2end_b_extra01"), ShowDialog("rank2end_b_extra02"), AwardRecipe("t_02"), AwardRecipe("t_03"), ShowRecipes(), ShowDialog("rank2end_b_extra03"), },
}

-- CHOCOLATIER () LEVEL QUESTS -----------------------------------------------

DefineQuest
{
	name = "rank3_01",
	requirements = {MinRank(3), RequireRecipe("t_02")},
	starter = "traveler16",
	accept = "youbet",
	goals = {RequireWeeks(8), RequireItem("t_02", 30)},
	rewards = {IncrementVar("rank3complete"), IncrementVar("plotpoints"), AwardRecipe("t_01"), ShowRecipes(), DelayQuest("rank3_end_hint", 5)},
}

DefineQuest
{
	name = "rank3_02",
	requirements = {MinRank(3), RequireRecipe("t_02"), RequireRecipeUnknown("t_05"), RequirePort("himalayas"),},
	starter = "sh_sassoonkeep",
	ender = "sh_shopkeep",
	goals = {RequireItem("t_02", 20)},
	rewards = {IncrementVar("rank3complete"), ShowDialog("rank3_02_extra01"), AwardMessage("rank3_02_msg"),},
}

DefineQuest
{
	name = "rank3_03",
	requirements = {MinRank(3), RequireRecipe("t_02")},
	starter = "man_farmkeep",
	accept = "iwill",
	gifts = {AwardRecipe("t_07"), ShowRecipes()},
	goals = {RequireItem("t_07", 85)},
	hintweeks = 18,
	rewards = {AwardItem("t_07", - 85), IncrementVar("rank3complete"), DelayQuest("rank3_end_hint", 5)},
}

DefineQuest
{
	name = "rank3_04",
	requirements = {MinRank(3), RequireRecipe("s_06"), RequireRecipe("t_02")},
	starter = "mos_otherkeep",
	gifts = {ShowDialog("rank3_04_extra01")},
	goals = {RequireItem("s_06", 60)},
	rewards = {IncrementVar("rank3complete"), AwardItem("s_06", - 60), AwardRecipe("t_09"), ShowRecipes(), DelayQuest("rank3_end_hint", 5), AwardMessage("rank3_04_complete_msg"),},
}

DefineQuest
{
	name = "rank3_05",
	requirements = {MinRank(3), RequireQuest("rank3_04"), RequireItem("t_09", 24)},
	starter = "mos_otherkeep",
	goals = {RequireItem("t_09", 24)},
	rewards = {IncrementVar("rank3complete"), AwardItem("t_09", - 24), AwardMoney(85000),},
}

DefineQuest
{
	name = "rank3_06",
	requirements = {MinRank(3)},
	starter = "sh_bundkeep",
	accept = "iwill",
	hintweeks = 41,
	goals = {RequireItem("t_06", 33)},
	rewards = {IncrementVar("rank3complete"), AwardItem("t_06", -33)},
	followUp = "rank3_07",
}

DefineQuest
{
	name = "rank3_07",
	requirements = {MinRank(3)},
	starter = "sh_bundkeep",
	ender = "ny_librarykeep",
	forceAccept = true,
	goals = {RequireItem("t_06", 1)},
	rewards = {IncrementVar("rank3complete"), AwardItem("t_06", -1), AwardRecipe("t_04"), ShowRecipes(), DelayQuest("rank3_end_hint", 5)},
}

DefineQuest
{
	name = "rank3_end_hint",
	requirements = {MinRank(3), MaxRank(3), RequireRecipesKnown("truffle",4)},
	starter = "sf_tutor",
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("rank3_end_hint", 37), DelayQuest("rank3_end", 3)},
}

DefineQuest
{
	name = "rank3_end",
	requirements = {MinRank(3), RequireRecipesKnown("truffle",7)},
	starter = "announcer",
	ender = "sf_tutor",
	summary = "backtoalex3",
	forceAccept = true,
	priority = true,
	rewards = {AwardRank(4), DelayQuest("factories_nudge", 27), IncrementVar("bcsign"), IncrementVar("rank3complete"), EnablePort("sydney")},
	followUp = "rank4_01",
}


-- MASTER CHOCOLATIER (RANK4) LEVEL QUESTS - END GAME -----------------------------------------


DefineQuest
{
	name = "rank4_01",
	requirements = {MinRank(4)},
	starter = "sf_tutor",
	ender = "syd_shopkeep",
	forceAccept = true,
	rewards = {SetHappy("syd_shopkeep"), IncrementVar("rank4complete"), ShowDialog("rank4_01_extra01"), ShowDialog("rank4_01_extra02"), AwardRecipe ("e_01"), ShowRecipes(),	DelayQuest("rank4_lab_e_03_nudge", 65), DelayQuest("rank4_lab_e_04_nudge", 65), DelayQuest("rank4_lab_e_05_nudge", 65), DelayQuest("rank4_lab_e_06_nudge", 65),  DelayQuest("rank4_lab_e_07_nudge", 65), DelayQuest("rank4_lab_e_08_nudge", 65), DelayQuest("rank4_lab_e_09_nudge", 65),  DelayQuest("rank4_lab_e_10_nudge", 65), DelayQuest("rank4_lab_e_11_nudge", 65), DelayQuest("rank4_lab_e_12_nudge", 65),},
}

DefineQuest
{
	name = "rank4_02",
	requirements = {MinRank(4), RequireRecipeUnknown("e_02"), RequirePort("sahara"), VarMoreThan("bombayopen",0)},
	starter = "sh_marketkeep",
	accept = "yesplease",
	ender = "bom_other1keep",
	hintweeks = 22,
	gifts = {ShowDialog("rank4_02_extra01")},
	goals = {RequireItem("e_02", 50)},
	rewards = {IncrementVar("rank4complete"), AwardItem("e_02", -50), AwardMoney(600000)},
}


DefineQuest
{
	name = "rank4_03",
	requirements = {MinRank(4), RequireRecipe("e_01")},
	starter = {"traveler01", "traveler03", "traveler04", "traveler05", "traveler09", "traveler12"},
	ender = "sf_tutor",
	accept = "ofcourse",
	reject = "notrightnow",
	summary = "backtoalex3",
	followUp = "rank4_04",
}

DefineQuest
{
	name = "rank4_04",
	requirements = {MinRank(4), RequireRecipe("e_01")},
	starter = "sf_tutor",
	ender = "ja_otherkeep",
	hintweeks = 29,
	goals = {RequireItem("e_01", 48)},
	followUp = "rank4_05a",
}

DefineQuest
{
	name = "rank4_05a",
	requirements = {MinRank(4), RequireRecipe("e_01")},
	starter = "ja_otherkeep",
	ender ="man_otherkeep",
	goals = {RequireItem("e_01", 48)},
	rewards ={AwardItem("e_01", -48)},
	followUp = "rank4_05",
}

DefineQuest
{
	name = "rank4_05",
	requirements = {MinRank(4), RequireRecipe("e_01")},
	starter = "man_otherkeep",
	ender ="ja_otherkeep",
	forceAccept = true,
	gifts = {AwardMessage("rank4_05_msg"), EnablePort("fiji"), SetVar("RecentlyInventedRecipes", 0)},
	goals = {VarMoreThan("RecentlyInventedRecipes", 2)},
	rewards ={AwardBuilding("ja_shop")},
}

DefineQuest
{
	name = "rank4_lab_e_03_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_03"), RequirePort("sahara")},
	starter = "traveler16",
	repeatable = true,
	rewards = {ShowDialog("rank4_lab_e_03_nudge_extra01"), AwardMessage ("rank4_lab_e_03_nudge_msg"), DelayQuest("rank4_lab_e_03_nudge", 35)},
	forceAccept = true,
}


DefineQuest
{
	name = "rank4_lab_e_04_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_04"), RequirePort("amazon"), RequireBuilding("ja_shop")},
	starter = "sf_tutor",
	ender = "ja_otherkeep",
	accept = "sure",
	reject = "notrightnow",
	hintweeks = 40,
	gifts = {ShowDialog("rank4_lab_e_03_nudge_extra01", "ja_otherkeep"), ShowDialog("rank4_lab_e_04_nudge_extra02", "ja_otherkeep"), AwardMessage("rank4_lab_e_04_nudge_msg"), AwardItem("ja_cacao", 1),  AwardItem("ma_cacao", 1), AwardItem("sugar", 1), AwardItem("mango", 1), AwardItem("plantain", 1), },
	goals = {RequireItem("e_04", 25)},
	rewards = {DelayQuest("rank4_lab_e_05_nudge", 29), DelayQuest("rank4_lab_e_06_nudge", 32), AwardItem("e_04", -25) },
	denial = {DelayQuest("rank4_lab_e_04_nudge", 19)},
}

DefineQuest
{
	name = "rank4_lab_e_05_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_05"), RequirePort("amazon"), RequireBuilding("ja_shop")},
	starter = "ja_otherkeep",
	repeatable = true,
	rewards = {DelayQuest("rank4_lab_e_04_nudge", 29), DelayQuest("rank4_lab_e_06_nudge", 39), AwardMessage ("rank4_lab_e_05_nudge_msg"), DelayQuest("rank4_lab_e_05_nudge", 35)},
	forceAccept = true,
}

DefineQuest
{
	name = "rank4_lab_e_06_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_06"), RequirePort("sahara")},
	starter = "traveler14",
	rewards = {DelayQuest("rank4_lab_e_06b_nudge", 20)},
	forceAccept = true,
}

DefineQuest
{
	name = "rank4_lab_e_06b_nudge",
	requirements = {RequireQuest("rank4_lab_e_06_nudge"), RequireRecipeUnknown("e_06")},
	starter = "traveler14",
	reject = "notrightnow",
	rewards = {AwardMessage("rank4_lab_e_06b_nudge_msg"), DelayQuest("rank4_lab_e_06b_nudge", 45)},
}

DefineQuest
{
	name = "rank4_lab_e_06_buysome",
	requirements = {RequireQuest("rank4_lab_e_06_nudge"), RequireItem("e_06", 24)},
	starter = "traveler14",
	accept = "youbet",
	reject = "nothankyou",
	forceOffer = true,
	denial = {ShowDialog("rank4_lab_e_06_buysome_extra01"), MarkComplete("rank4_lab_e_06_buysome")},
	rewards = {AwardItem("e_06", - 24), AwardMoney(650000)},
}

DefineQuest
{
	name = "rank4_lab_e_07_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_07"), RequireBuilding("ca_shop")},
	starter = "ca_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("rank4_lab_e_07_nudge_msg"), DelayQuest("rank4_lab_e_07_nudge", 52)},
}

DefineQuest
{
	name = "rank4_lab_e_08_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_08"), RequireBuilding("sj_shop"), RequirePort("sahara"),},
	starter = "sj_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("rank4_lab_e_08_nudge_msg"), DelayQuest("rank4_lab_e_08_nudge", 32)},
}

DefineQuest
{
	name = "rank4_lab_e_09_nudge",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_09"), RequireBuilding("cas_shop"), RequirePort("himalayas"),},
	starter = "cas_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("rank4_lab_e_09_nudge_msg"), DelayQuest("rank4_lab_e_09_nudge", 40), DelayQuest("rank4_lab_e_10_nudge", 5)},
}

DefineQuest
{
	name = "rank4_lab_e_10_nudge",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_10"), RequireBuilding("cas_shop"), RequirePort("himalayas"),},
	starter = "cas_shopkeep",
	accept = "indeed",
	reject = "notrightnow",
	ender = "ab_farmkeep",
	repeatable = true,
	rewards = {AwardMessage("rank4_lab_e_10_nudge_msg"), DelayQuest("rank4_lab_e_10_nudge", 37), DelayQuest("rank4_lab_e_09_nudge", 5)},
	denial = {DelayQuest("rank4_lab_e_10_nudge", 19)},
}

DefineQuest
{
	name = "rank4_lab_e_11_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_11"), RequireBuilding("ca_shop"), RequirePort("fiji"),},
	starter = "ca_shopkeep",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("rank4_lab_e_11_nudge", 42)},
}

DefineQuest
{
	name = "rank4_lab_e_12_nudge",
	requirements = {MinRank(4), RequireRecipe("e_01"), RequireRecipeUnknown("e_12"), RequireBuilding("sh_factory"), RequireBuilding("syd_factory"), RequireBuilding("ca_shop"), RequireBuilding("cas_shop"), RequireBuilding("ja_shop"), RequireBuilding("sj_shop"), RequirePort("fiji"),},
	starter = "traveler15",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("rank4_lab_e_12_nudge", 36)},
}

DefineQuest
{
	name = "takeover_01_factoryhint",
	requirements = {RequireQuestIncomplete("takeover_01"), MinRank(4), VarEquals("evilover", 7), RequireRecipesKnown("exotic", 6), RequireNoMedal("factory"), RequireTotalRecipesKnown(50)},
	starter = "sf_tutor",
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("takeover_01_factoryhint", 66)},
}

DefineQuest
{
	name = "takeover_01",
	requirements = {MinRank(4), VarEquals("evilover", 7), RequireRecipesKnown("exotic", 6), RequireMedal("factory"), RequireTotalRecipesKnown(50)},
	starter = "announcer",
	ender = "sf_tutor",
	summary = "backtoalex3",
	forceAccept = true,
	priority = true,
--	forceOffer = true,
	rewards = {ShowDialog("takeover_01_extra01")},
	followUp = "takeover_02",
}


DefineQuest
{
	name = "takeover_02",
	requirements = {MinRank(4), RequireRecipesKnown("exotic", 6), RequireTotalRecipesKnown(50)},
	starter = "sf_tutor",
	ender = "cay_hotelkeep",
	goals = {RequireItem("e_01", 50)},
	gifts = {ShowDialog("takeover_02_extra01")},
	rewards = {IncrementVar("bcowned"), AwardItem("e_01", - 50) },
	followUp = "takeover_03",
}

DefineQuest
{
	name = "takeover_03",
	requirements = {MinRank(4), RequireRecipesKnown("exotic", 6), RequireTotalRecipesKnown(50)},
	starter = "cay_hotelkeep",
	ender = "sf_tutor",
	forceAccept = true,
	rewards = {DelayQuest("takeover_stalled", 44), ShowDialog("takeover_03_extra01"), DelayQuest("takeover_04", 5), DelayQuest("takeover_04_nudge", 5), DelayQuest("takeover_05", 5), DelayQuest("takeover_05_nudge", 5), DelayQuest("takeover_06", 5), DelayQuest("takeover_06_nudge", 5), SetVar("takeover", 3)},
}

DefineQuest
{
	name = "takeover_beg_story01",
	requirements = {MinRank(4), VarEquals("takeover", 3)},
	starter = "sf_tutor",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "takeover_04_nudge",
	requirements = {RequireQuestIncomplete("takeover_04"), RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_08")},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14"},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("takeover_04_nudge", 37),},
}

DefineQuest
{
	name = "takeover_04",
	requirements = {RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_08")},
	starter = "sf_tutor",
	ender = "sj_farmkeep",
	forceOffer = true,
	gifts = {SetVar("takeover", 4)},
	goals = {RequireItem("e_08", 75)},
	rewards = {DelayQuest("takeover_05_nudge", 29), IncrementVar("bcowned"), SetHappy("sj_farmkeep"), AwardItem("e_08", -75), DelayQuest("takeover_stalled", 34)},
}

DefineQuest
{
	name = "takeover_05_nudge",
	requirements = {RequireQuestIncomplete("takeover_05"), RequireQuest("cas_shopkeep_rank2_story01"), RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_09"), RequireRecipe("e_10")},
	starter = {"traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14"},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("takeover_05_nudge", 47),},
}

DefineQuest
{
	name = "takeover_05",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_09"), RequireRecipe("e_10") },
	starter = "sf_tutor",
	ender = "cas_shopkeep",
	forceOffer = true,
	gifts = {SetVar("takeover", 4)},
	goals = {RequireItem("e_09", 100), RequireItem("e_10", 100)},
	rewards = {IncrementVar("bcowned"), SetHappy("cas_shopkeep"), AwardItem("e_09", - 100), AwardItem("e_10", -100), DelayQuest("takeover_stalled",34)},
}

DefineQuest
{
	name = "takeover_06_nudge",
	requirements = {RequireQuestIncomplete("takeover_06"), RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_03"), RequireRecipe("e_05"), RequireRecipe("e_06")},
	starter = {"traveler01", "traveler02", "traveler03", "traveler09", "traveler10", "traveler11", "traveler12", "traveler13", "traveler14"},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("takeover_06_nudge", 49),},
}

DefineQuest
{
	name = "takeover_06",
	requirements = {RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_03"), RequireRecipe("e_05"), RequireRecipe("e_06")},
	starter = "sf_tutor",
	ender = "syd_shopkeep",
	forceOffer = true,
	gifts = {SetVar("takeover", 4)},
	goals = {RequireItem("e_03", 200)},
	rewards = {SetHappy("syd_shopkeep"), AwardItem("e_03", - 200), DelayQuest("takeover_stalled",34)},
	followUp = "takeover_06b",
}


DefineQuest
{
	name = "takeover_06b",
	starter = "syd_shopkeep",
	ender = "him_mountainkeep",
	forceAccept = true,
	goals = {RequireItem("e_05", 200)},
	rewards = { SetHappy("syd_shopkeep"), AwardItem("e_03", - 200), DelayQuest("takeover_stalled",34)},
	followUp = "takeover_06c",
}


DefineQuest
{
	name = "takeover_06c",
	requirements = {RequireQuest("takeover_03"), MinRank(4), RequireRecipe("e_03"), RequireRecipe("e_05"), RequireRecipe("e_06")},
	starter = "him_mountainkeep",
	ender = "sf_tutor",
	gifts = {SetVar("takeover", 4)},
	goals = {RequireItem("e_06", 12), RequireItem("rose", 12)},
	rewards = {IncrementVar("bcowned"), DelayQuest("gameover_recipesneeded_nudge", 79), SetHappy("sf_tutor"),  ShowDialog("takeover_06c_extra01"), AwardItem("rose", - 12), AwardItem("e_06", - 12), DelayQuest("takeover_stalled",34)},
}

DefineQuest
{
	name = "takeover_going",
	requirements = {RequireQuest("takeover_03"), MinRank(4), RequireNoMedal("exotic"), VarLessThan("bcowned",4)},
	starter = "sf_tutor",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "takeover_stalled",
	requirements = {RequireQuest("takeover_03"), MinRank(4), RequireNoMedal("exotic"), VarLessThan("bcowned",4)},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("takeover_stalled", 40)},
}

DefineQuest
{
	name = "gameover_recipesneeded_nudge",
	requirements = {RequireQuestIncomplete("gameover"), RequireQuest("takeover_03"), RequireNoMedal("exotic"), VarEquals("bcowned", 4), MinRank(4)},
	starter = "announcer",
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("gameover_recipesneeded_nudge", 79),},
}

DefineQuest
{
	name = "almostover_recipesneeded",
	requirements = {RequireQuestIncomplete("gameover"), RequireQuest("takeover_03"), RequireNoMedal("exotic"), VarEquals("bcowned", 4), MinRank(4)},
	starter = "sf_tutor",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "gameover_nudge",
	requirements = {RequireQuestIncomplete("gameover"), RequireQuest("takeover_03"), RequireMedal("exotic"), VarEquals("bcowned", 4), MinRank(4)},
	starter = {"traveler02", "traveler04", "traveler06", "traveler09", "traveler10", "traveler11", "traveler07", "traveler13", "traveler14"},
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("gameover_nudge", 69),},
}

DefineQuest
{
	name = "gameover",
	requirements = {RequireQuest("takeover_03"), RequireMedal("exotic"), VarEquals("bcowned", 4), MinRank(4)},
	starter = "sf_tutor",
	ender = "sf_bchqkeep",
	forceOffer = true,
	gifts = {ShowDialog("gameover_extra01"), SetVar("takeover", 4)},
	goals = {RequireItem("e_01", 100), RequireItem("e_02", 100), RequireItem("e_03", 100), RequireItem("e_04", 100), RequireItem("e_05", 100), RequireItem("e_06", 100), RequireItem("e_07", 100), RequireItem("e_08", 100), RequireItem("e_09", 100), RequireItem("e_10", 100), RequireItem("e_11", 100), RequireItem("e_12", 100)},
	rewards = {SetHappy("sf_bchqkeep"), SetHappy("sf_tutor"), ShowDialog("gameover_extra02"), AwardItem("e_01", -1), AwardItem("e_02", -1), AwardItem("e_03", -1), AwardItem("e_04", -1), AwardItem("e_05", -1), AwardItem("e_06", -1), AwardItem("e_07", -1), AwardItem("e_08", -1), AwardItem("e_09", -1), AwardItem("e_10", -1), AwardItem("e_11", -1), AwardItem("e_12", -1), ShowDialog("gameover_extra03", "sf_tutor"), ShowDialog("gameover_extra04", "sf_tutor"), SetVar("bcsign", 6), AwardRank(5), GameOver()},
}


-- AIRPLANE  QUESTS -----------------------------------------------------

DefineQuest
{
	name = "airplane",
	requirements = {MinMoney(2849000), MinRank(3), VarLessThan("OwnAirplane",1) },
	starter = "announcer",
--	forceOffer = true,
	accept = "iwantit",
	reject = "nothanks",
	denial = {DelayQuest("airplane", 52)},
	rewards = {AwardMoney(-2500000), IncrementVar("OwnAirplane"), IncrementVar("airship"), AwardMessage("airplane_msg")},
}


-- LABORATORY  QUESTS -----------------------------------------------------

DefineQuest
{
	name = "lab02_nudge",
	requirements = { MinRank(2), MinWeek(45), RequireNoMedal("lab"),},
	starter = {"traveler02", "traveler05", "traveler06"}, 
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("lab02_nudge", 33)},
}

DefineQuest
{
	name = "lab01_nudge",
	requirements = { MinRank(1), MinWeek(17), RequireNoMedal("lab"),},
	starter = "traveler02",
	priority = true,
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("lab01_nudge", 40)},
}

DefineQuest
{
	name = "lab01",
	requirements = { MinRank(2), MinMoney(155000), RequirePort("amazon"), RequireNoMedal("lab")},
	starter = {"traveler01", "traveler02", "traveler05", "traveler06", "traveler07", "traveler10"},
	ender = "ba_labkeep",
--	forceOffer = true,
	priority = true,
--	followUp = "lab02",
}


DefineQuest
{
	name = "lab_owned",
	requirements = {RequireBuilding("ba_lab")},
	starter = "ba_labkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "lab_hint",
	requirements = {RequireBuilding("ba_lab")},
	starter = "pa_marketkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "lab01_owned_reminder",
	requirements = {MinRank(2), RequireBuilding("ba_lab"),},
	starter = {"traveler02", "traveler05", "traveler06"}, 
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("lab01_owned_reminder", 77)},
}

DefineQuest
{
	name = "lab_i_03_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequirePort("sahara"), RequireRecipeUnknown("i_03"),},
	starter = "traveler06",
	forceAccept = true,
	forceOffer = true,
	repeatable = true,
	rewards = {AwardMessage("lab_i_03_nudge_msg"), DelayQuest("lab_i_03_nudge", 130)},
}

DefineQuest
{
	name = "lab_s_05_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipe("s_01"), RequireRecipeUnknown("s_05"), RequirePort("sahara")},
	starter = "ba_labkeep",
	forceAccept = true,
	rewards = {DelayQuest("lab_s_05_b_nudge", 32)},
}

DefineQuest
{
	name = "lab_s_05_b_nudge",
	requirements = {RequireQuest("lab_s_05_nudge"), RequireBuilding("ba_lab"), MinRank(2), RequireRecipe("s_01"), RequireRecipeUnknown("s_05"), RequirePort("sahara")},
	starter = "ba_labkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_s_05_b_nudge_msg"), DelayQuest("lab_s_05_b_nudge", 29)},
}

DefineQuest
{
	name = "lab_s_08_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipe("s_01"), RequireRecipeUnknown("s_08"), RequirePort("sahara")},
	starter = "traveler15",
	ender = "sa_oasiskeep",
	accept = "yesiam",
	gifts = {ShowDialog("lab_s_08_nudge_extra"), DelayQuest("lab_s_08_nudge", 99)},
	reject = "notrightnow",
	repeatable = true,
	denial = {DelayQuest("lab_s_08_nudge", 59)},
}


DefineQuest
{
	name = "lab_s_09_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipe("s_01"), RequireRecipeUnknown("s_09"), RequirePort("amazon")},
	starter = "ab_farmkeep",
	ender = "ba_labkeep",
	accept = "yesiam",
	gifts = {AwardMessage("lab_s_09_nudge_msg"), ShowDialog("lab_s_09_nudge_extra")},
	reject = "notrightnow",
	repeatable = true,
	goals = {RequireLabItem("ab_cacao")},
	denial = {DelayQuest("lab_s_09_nudge",26)},
}

DefineQuest
{
	name = "lab_p_08_nudge_nudge",
	requirements = {RequireQuestIncomplete("lab_p_08_nudge"), RequireBuilding("ba_lab"), MinRank(2), RequirePort("bombay"), RequireRecipe("p_01"), RequireRecipeUnknown("p_08")},
	starter = "traveler05",
	ender = "bom_other2keep",
	forceOffer = true,
	accept = "yesplease",
	reject = "notrightnow",
	hintweeks = 25,
	repeatable = true,
	rewards = {OfferQuest("lab_p_08_nudge")},
	denial = {DelayQuest("lab_p_08_nudge_nudge", 36)},
}

DefineQuest
{
	name = "lab_p_08_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(2), RequireRecipe("p_01"), RequireRecipeUnknown("p_08")},
	starter = "bom_other2keep",
	accept = "youbet",
	gifts = {ShowDialog("lab_p_08_nudge_extra"), EnablePort("himalayas"), DelayQuest("lab_p_12_nudge", 46), DelayQuest("lab_t_11_nudge", 56), DelayQuest("rank3_02", 26),},
	reject = "notrightnow",
	repeatable = true,
	hintweeks = 31,
	goals = {RequireItem("p_08", 25)},
	denial = {DelayQuest("lab_p_08_nudge", 36)},
}

DefineQuest
{
	name = "lab_p_10_hint",
	requirements = {RequireBuilding("ba_lab"), MinRank(3), RequireRecipe("p_01"), RequireRecipeUnknown("p_10"), RequirePort("fiji")},
	starter = "traveler11",
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("lab_p_10_hint", 30), AwardMessage("lab_p_10_hint_msg"),},
}

DefineQuest
{
	name = "lab_p_11_nudge",
	requirements = {RequireBuilding("ba_lab"), RequireRecipe("p_01"), RequireRecipeUnknown("p_11"), RequirePort("sahara")},
	starter = "traveler10",
	accept = "pleasedo",
	reject = "nothanks",
	ender = "ba_labkeep",
	gifts = {ShowDialog("lab_p_11_nudge_extra01")},
	goals = {RequireLabItem("sj_cacao"), RequireLabItem("ca_cacao"), RequireLabItem("ma_cacao"), RequireLabItem("currant"), RequireLabItem("sugar")},
	repeatable = true,
	denial = {DelayQuest("lab_p_11_nudge", 30), ShowDialog("lab_p_11_nudge_extra02"),},
	followUp = "lab_p_11_nudgeb",
}

DefineQuest
{
	name = "lab_p_11_nudgeb",
--	requirements = {RequireBuilding("ba_lab"), RequireRecipe("p_01"), RequireRecipeUnknown("p_11"), RequirePort("sahara")},
	starter = "ba_labkeep",
	ender = "traveler10",
	forceAccept = true,
	goals = {RequireWeeks(11), RequireItem("p_11", 24)},
	rewards = {AwardItem("p_11", -24)},
}

DefineQuest
{
	name = "lab_p_12_nudge",
	requirements = {RequireBuilding("ba_lab"), RequireBuilding("ca_shop"), RequireRecipe("p_01"), RequireRecipeUnknown("p_12"), RequirePort("himalayas"), RequirePort("jakarta")},
	starter = "ca_shopkeep",
	accept = "yesiwould",
	reject = "nothanks",
	ender = "ba_labkeep",
	gifts = {ShowDialog("lab_p_12_nudge_extra01")},
	goals = {RequireLabItem("sj_cacao"), RequireLabItem("ab_cacao"), RequireLabItem("sj_cacao"), RequireLabItem("cinnamon"), RequireLabItem("lavender"), RequireLabItem("sugar")},
	repeatable = true,
	forceOffer = true,
	denial = {DelayQuest("lab_p_12_nudge", 40)},
	followUp = "lab_p_12_nudgeb",
}

DefineQuest
{
	name = "lab_p_12_nudgeb",
--	requirements = {RequireBuilding("ba_lab"), RequireRecipeUnknown("p_11"), RequirePort("sahara")},
	starter = "ba_labkeep",
	ender = "ca_shopkeep",
	forceAccept = true,
	goals = {RequireRecipe("p_12")},
}


DefineQuest
{
	name = "lab_t_08_nudge01",
	requirements = {RequireBuilding("ba_lab"), MinRank(3), RequireRecipeUnknown("t_08"),},
	starter = "ab_farmkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_t_08_nudge_msg"), DelayQuest("lab_t_08_nudge01", 38), DelayQuest("lab_t_08_nudge02", 38)},
}

DefineQuest
{
	name = "lab_t_08_nudge02",
	requirements = {RequireBuilding("ba_lab"), MinRank(3), RequireRecipeUnknown("t_08"),},
	starter = "ma_farmkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_t_08_nudge_msg"), DelayQuest("lab_t_08_nudge01", 38), DelayQuest("lab_t_08_nudge02", 38)},
}

DefineQuest
{
	name = "lab_t_10_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(3), RequireRecipeUnknown("t_10"), RequirePort("fiji")},
	starter = "fiji_hutkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_t_10_nudge_msg"), DelayQuest("lab_t_10_nudge", 30)},
}

DefineQuest
{
	name = "lab_t_11_nudge",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), RequireBuilding("ba_lab"), RequireBuilding("cas_shop"), MinRank(3), RequireRecipeUnknown("t_11"), RequirePort("himalayas")},
	starter = "cas_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_t_11_nudge_msg"), DelayQuest("lab_t_11_nudge", 27)},
}

DefineQuest
{
	name = "lab_t_12_nudge",
	requirements = {RequireBuilding("ba_lab"), MinRank(3), RequireRecipeUnknown("t_12"), RequirePort("fiji")},
	starter = "syd_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("lab_t_12_nudge_msg"), DelayQuest("lab_t_12_nudge", 30)},
}

DefineQuest
{
	name = "lab_allinventedrecipes",
	requirements = {RequireBuilding("ba_lab"), RequireNoMedal("exotic"), VarEquals("InventedRecipes", 28)},
	starter = "ba_labkeep",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "lab_allrecipes",
	requirements = {RequireBuilding("ba_lab"), RequireMedal("exotic")},
	starter = "ba_labkeep",
	forceAccept = true,
	repeatable = true,
}

-- MAKE-UP QUESTS -----------------------------------------------------
-- these enable players to reach ports, collect recipes, etc. if they miss other 'optional' opportunities
-- these are not necessary to complete story mode etc.


DefineQuest
{
	name = "bombay_alt",
	requirements = {MinRank(3), MinMoney(1000000), RequireBuilding("ba_lab"), RequireQuest("rank2_mid"), RequireQuestIncomplete("ca_shopown_07")},
	starter = "lender",
--	repeatable = true,
	denial = {DelayQuest("bombay_alt", 132), ShowDialog("bombay_alt_denial"),},
	rewards = {AwardMoney(-500000), EnablePort("bombay"), IncrementVar("bombayopen"), DelayQuest("lab_p_08_nudge", 75), DelayQuest("lab_p_08_nudge_nudge", 75)},
}

-- SHOP-OWNING QUESTS -----------------------------------------------------

-- SAN JOSE SHOP-OWNING QUESTS --------------------------------------------


DefineQuest
{
	name = "sj_shopown_01_nudge",
	requirements = {RequireQuestIncomplete("sj_shopown_01"), MinRank(2), RequireBuilding("ba_lab"), RequirePort("amazon")},
	starter = {"traveler02", "traveler06", "traveler07", "traveler11", "traveler12"},
	ender = "sj_shopkeep",
	accept = "iwould",
	reject = "notrightnow",
	repeatable = true,
	rewards = {OfferQuest("sj_shopown_01")},
	denial = {DelayQuest("sj_shopown_01_nudge", 38)},
}


DefineQuest
{
	name = "sj_shopown_01",
	requirements = { MinRank(2), RequireBuilding("ba_lab"), RequirePort("amazon")},
	starter = "sj_shopkeep",
	forceAccept = true,
	rewards = {RaiseMood("sj_shopkeep", 35), IncrementVar("sj_shopown")},
	followUp = "sj_shopown_02",
}

DefineQuest
{
	name = "sj_shopown_02",
	starter = "sj_shopkeep",
	goals = {RequireItem("i_06", 60)},
	hintweeks = 20,
	rewards = {SetHappy("sj_shopkeep"), IncrementVar("HaggleBonus"), IncrementVar("sj_shopown"), DelayQuest("sj_shopown_03_nudge", 3), DelayQuest("sj_shopown_03",3),}
}

DefineQuest
{
	name = "sj_shopown_03_nudge",
	requirements = { RequireQuestIncomplete("sj_shopown_03"), VarMoreThan("sj_shopown", 1), MaxMoney(75000)},
	starter = "sj_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {DelayQuest("sj_shopown_03_nudge", 5)},
}

DefineQuest
{
	name = "sj_shopown_03",
	requirements = { VarMoreThan("sj_shopown", 1), MinMoney(75001)},
	starter = "sj_shopkeep",
	rewards = {IncrementVar("plotpoints"), AwardMoney(-75000), AwardBuilding("sj_shop"),},
}

DefineQuest
{
	name = "sj_shopowned_01",
	requirements = {RequireBuilding("sj_shop")},
	starter = "sj_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("sj_shopkeep"), DelayQuest("sj_shopowned_01", 15)},
}

DefineQuest
{
	name = "sj_shopowned_02",
	requirements = {RequireBuilding("sj_shop")},
	starter = "sj_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("sj_shopkeep"), DelayQuest("sj_shopowned_02", 15)},
}
-- CASABLANCA SHOP-OWNING QUESTS --------------------------------------------


DefineQuest
{
	name = "cas_shopown_01_nudge",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), RequirePort("casablanca"), RequireQuestIncomplete("cas_shopown_01"), MinRank(2), RequireBuilding("ba_lab"), RequireRecipe("s_01")},
	starter = {"traveler03", "traveler04", "traveler05", "traveler09", "traveler10", "traveler11", "traveler02"},
	ender = "cas_shopkeep",
	accept = "sure",
	reject = "notrightnow",
	repeatable = true,
	rewards = {OfferQuest("cas_shopown_01")},
	denial = {DelayQuest("cas_shopown_01_nudge", 18)},
}

DefineQuest
{
	name = "cas_shopown_01",
	requirements = {RequireQuest("cas_shopkeep_rank2_story01"), MinRank(2), RequireBuilding("ba_lab"), RequireRecipe("s_01"), },
	starter = "cas_shopkeep",
	forceAccept = true,
	rewards = {IncrementVar("cas_shopown"), DelayQuest("cas_shopown_02", 4), DelayQuest("cas_shopown_02_nudge", 34)},
}

DefineQuest
{
	name = "cas_shopown_02_nudge",
	requirements = {RequireQuest("cas_shopown_01"), RequireQuestIncomplete("cas_shopown_02")},
	starter = "talker",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("cas_shopown_02_nudge_msg"), DelayQuest("cas_shopown_02_nudge", 45)},
}

DefineQuest
{
	name = "cas_shopown_02",
	requirements = {RequireQuest("cas_shopown_01"), MinRank(2), RequireBuilding("ba_lab"), RequireRecipe("s_01"), },
	starter = "cas_shopkeep",
	accept = "iwill",
	ender = "sj_farmkeep",
	gifts = {AwardRecipe("s_07"), ShowRecipes()},
	goals = {RequireItem("s_07", 100)},
	rewards = {AwardItem("s_07", -100), IncrementVar("cas_shopown")},
	followUp = "cas_shopown_03",
}


DefineQuest
{
	name = "cas_shopown_03",
	requirements = {RequireQuest("cas_shopown_01"), MinRank(2), RequireBuilding("ba_lab"), RequireRecipe("s_01")},
	starter = "sj_farmkeep",
	ender = "cas_shopkeep",
	forceAccept = true,
	rewards = {ShowDialog("cas_shopown_03_extra01"), AwardRecipe("s_06"), ShowRecipes(), IncrementVar("cas_shopown")},
	followUp = "cas_shopown_04",
}

DefineQuest
{
	name = "cas_shopown_04",
	requirements = {VarMoreThan("cas_shopown", 2)},
	starter = "cas_shopkeep",
	ender = "cas_marketkeep",
	gifts = {AwardMoney(35000), AwardMessage("cas_shopown_04_msg"), ShowDialog("cas_shopown_04_extra01")},
	goals = {RequireItem("rose", 12), RequireItem("tulip", 12)},
	rewards = {DelayQuest("cas_shopown_05_nudge", 40), SetHappy("cas_shopkeep"), IncrementVar("cas_shopown"), AwardItem("rose", -12), AwardItem("tulip", -12)},
}

DefineQuest
{
	name = "cas_shopown_05_nudge",
	requirements = {RequireQuest("cas_shopown_04"), RequireQuestIncomplete("cas_shopown_05"), VarMoreThan("cas_shopown", 3)},
	starter = "talker",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("cas_shopown_05_nudge_msg"), DelayQuest("cas_shopown_05_nudge", 45)},
}

DefineQuest
{
	name = "cas_shopown_05",
	requirements = {RequireQuest("cas_shopown_04"), VarMoreThan("cas_shopown", 3)},
	starter = "cas_shopkeep",
	accept = "ofcourse",
	hintweeks = 30,
	gifts = {SetHappy("cas_shopkeep"), ShowDialog("cas_shopown_05_extra01"), EnablePort("sahara"), SetVar("RecentlyInventedRecipes", 0)},
	goals = {VarMoreThan("RecentlyInventedRecipes", 0)},
	rewards = {SetHappy("cas_shopkeep"), DelayQuest("cas_shopown_06", 3), IncrementVar("cas_shopown"), DelayQuest("lab_s_05_b_nudge", 38), DelayQuest("lab_s_05_nudge", 38), DelayQuest("lab_i_03_nudge", 48)},
}

DefineQuest
{
	name = "cas_shopown_06_nudge",
	requirements = {RequireQuestIncomplete("cas_shopown_06"), MinMoney(125000), RequireQuest("cas_shopown_05"), VarMoreThan("cas_shopown", 4)},
	starter = {"traveler03", "traveler04", "traveler05", "traveler09", "traveler10", "traveler11", "traveler02"},
	ender = "cas_shopkeep",
	repeatable = true,
	rewards = {OfferQuest("cas_shopown_06")},
	denial = {DelayQuest("cas_shopown_06_nudge", 40)},
}

DefineQuest
{
	name = "cas_shopown_06",
	requirements = {MinMoney(125000),RequireQuest("cas_shopown_05"), VarMoreThan("cas_shopown", 4)},
	starter = "cas_shopkeep",
	denial = {ShowDialog("cas_shopown_06_sayno")},
	rewards = {SetHappy("cas_shopkeep"), IncrementVar("cas_shopown"), AwardMoney(-125000), AwardBuilding("cas_shop")},
}

DefineQuest
{
	name = "cas_shopowned_01",
	requirements = {RequireBuilding("cas_shop")},
	starter = "cas_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("cas_shopkeep"), DelayQuest("cas_shopowned_01", 15)},
}

DefineQuest
{
	name = "cas_shopowned_02",
	requirements = {RequireBuilding("cas_shop")},
	starter = "cas_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("cas_shopkeep"), DelayQuest("cas_shopowned_02", 15)},
}
-- CAIRO SHOP-OWNING QUESTS --------------------------------------------


DefineQuest
{
	name = "ca_shopown_nudge1",
	requirements = { MinRank(2), RequireBuilding("ba_lab"), VarMoreThan("ca_shopown",1), VarLessThan("ca_shopown", 7)},
	starter = "traveler09",
	forceAccept = true,
	repeatable = true,
	rewards = {AwardMessage("ca_shopown_nudge1_msg"), SetHappy("cas_shopkeep"), DelayQuest("ca_shopown_nudge1", 65)},

}

DefineQuest
{
	name = "ca_shopown_01",
	requirements = { MinRank(2), RequireBuilding("ba_lab"), VarMoreThan("ca_shopown",1)},
	starter = "ca_shopkeep",
	rewards = {IncrementVar("ca_shopown")},
	followUp = "ca_shopown_02",
}


DefineQuest
{
	name = "ca_shopown_02",
	requirements = {VarMoreThan("ca_shopown",2), RequireRecipe("p_03"), },
	starter = "ca_shopkeep",
	ender = "pa_moulinkeep",
	goals = {RequireItem("p_03", 60)},
	rewards = {AwardItem("p_03", -60), IncrementVar("ca_shopown")},
}

DefineQuest
{
	name = "ca_shopown_03_nudge",
	requirements = {RequireQuest("ca_shopown_02"), RequireQuestIncomplete("ca_shopown_03"), },
	starter = "traveler03",
	ender = "ca_shopkeep",
	repeatable = true,
	denial = {DelayQuest("ca_shopown_03_nudge", 91)},
	rewards = {DelayQuest("ca_shopown_03_nudge", 73), OfferQuest("ca_shopown_03"),},
}


DefineQuest
{
	name = "ca_shopown_03",
	requirements = {VarMoreThan("ca_shopown", 3)},
	starter = "ca_shopkeep",
	ender = "cas_otherkeep",
	gifts = {AwardRecipe("p_05"), ShowRecipes()},
	goals = {RequireItem("p_05", 75)},
	rewards = {AwardItem("p_05", -75), IncrementVar("ca_shopown")},
	followUp = "ca_shopown_04",
}

DefineQuest
{
	name = "ca_shopown_04",
	requirements = {VarMoreThan("ca_shopown",4)},
	starter = "cas_otherkeep",
	ender = "ca_shopkeep",
	gifts = {AwardItem("p_03", 12)},
	goals = {RequireItem("p_03", 12)},
	rewards = {IncrementVar("ca_shopown"), AwardItem("p_03", -12)},
	followUp = "ca_shopown_05",
}

DefineQuest
{
	name = "ca_shopown_05",
	requirements = {VarMoreThan("ca_shopown", 5)},
	starter = "ca_shopkeep",
	ender = "ba_teatrokeep",
	gifts = {AwardRecipe("p_07"), ShowRecipes()},
	goals = {RequireItem("p_07", 96)},
	rewards = {AwardItem("p_07", -96), IncrementVar("ca_shopown")},
}

DefineQuest
{
	name = "ca_shopown_06_nudge",
	requirements = {RequireQuest("ca_shopown_05"), RequireQuestIncomplete("ca_shopown_06")},
	starter = "traveler05",
	ender = "ca_shopkeep",
	repeatable = true,
	denial = {DelayQuest("ca_shopown_06_nudge", 81)},
	rewards = {DelayQuest("ca_shopown_06_nudge", 93), OfferQuest("ca_shopown_06"),},
}

DefineQuest
{
	name = "ca_shopown_06",
	requirements = {VarMoreThan("ca_shopown", 6)},
	starter = "ca_shopkeep",
	ender = "mos_shopkeep",
	hintweeks = 22,
	gifts = {ShowDialog("ca_shopown_06_extra01"), AwardRecipe("p_04"), ShowRecipes(), ShowDialog("ca_shopown_06_extra02") },
	goals = {RequireItem("p_04", 60), RequireItem("orchid", 1)},
	rewards = {SetHappy("mos_shopkeep"), AwardItem("p_04", -60), AwardItem("orchid", -1), IncrementVar("ca_shopown"), DelayQuest("lab_s_05_b_nudge", 38), DelayQuest("lab_s_05_nudge", 38), DelayQuest("lab_i_03_nudge", 48)},
	followUp = "ca_shopown_07",
}

DefineQuest
{
	name = "ca_shopown_07",
	requirements = {VarMoreThan("ca_shopown", 7)},
	starter = "mos_shopkeep",
	ender = "ca_shopkeep",
	rewards = {SetHappy("ca_shopkeep"), ShowDialog("ca_shopown_07_extra01"), ShowDialog("ca_shopown_07_extra02"), AwardMessage("ca_shopown_07_msg"), AwardBuilding("ca_shop"), EnablePort("bombay"), IncrementVar("bombayopen"), IncrementVar("ca_shopown"), DelayQuest("lab_p_08_nudge", 45), DelayQuest("lab_p_08_nudge_nudge", 45)},
}

DefineQuest
{
	name = "ca_shopowned_01",
	requirements = {RequireBuilding("ca_shop")},
	starter = "ca_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("ca_shopkeep"), DelayQuest("ca_shopowned_01", 15)},
}

DefineQuest
{
	name = "ca_shopowned_02",
	requirements = {RequireBuilding("ca_shop")},
	starter = "ca_shopkeep",
	forceAccept = true,
	repeatable = true,
	rewards = {SetHappy("ca_shopkeep"), DelayQuest("ca_shopowned_02", 15)},
}

-- MANILLA SHOP-OWNING QUESTS --------------------------------------------

-- AMAZON QUESTS -----------------------------------------------------

DefineQuest
{
	name = "am_reveal",
	requirements = { MinRank(1), MinWeek(33), MinMoney(15000), RequireTotalRecipesKnown(7)},
	starter = {"traveler14", "traveler13", "traveler10", "traveler09", "traveler11",},
	forceOffer = true,
	accept = "takeit",
	reject = "nothanks",
	rewards = {AwardMoney(-10000), ShowDialog("am_reveal_extra01"), EnablePort("amazon"), DelayQuest("noviceend", 3)}
}

DefineQuest
{
	name = "am_reveal_nudge",
	requirements = {RequireQuestIncomplete("am_reveal"), MinRank(2), MinWeek(37), MaxMoney(14999)},
	starter = {"traveler14", "traveler13", "traveler02", "traveler03", "traveler05", "traveler06", "traveler09", "traveler11",},
	forceOffer = true,
	rewards = {DelayQuest("am_reveal_nudge", 13)},
	repeatable = true,
}

DefineQuest
{
	name = "am01",
	requirements = {MinRank(1)},
	starter = "am_hutkeep",
	forceAccept = true,
--	rewards = {AwardMoney(-150000), AwardItem("ant", 200), ShowRecipes(),}
}

-- NOMONEY QUESTS -----------------------------------------------------

DefineQuest
{
	name = "nomoney",
	requirements = {MaxMoney(250), MinRank(1) },
	starter = "lender",
	forceOffer = true,
	gifts = {AwardMoney(3000)},
	goals = { RequireWeeks(4) , MinMoney(4500)},
	rewards ={ AwardMoney(-4500), IncrementVar("nomoney"),},
}

DefineQuest
{
	name = "nomoney2",
	requirements = {MaxMoney(250), VarEquals("nomoney",1) },
	starter = "lender",
	forceOffer = true,
	gifts = {AwardMoney(3000)},
	goals = { RequireWeeks(4) , MinMoney(5000)},
	rewards ={ AwardMoney(-5000), IncrementVar("nomoney"),},
}

DefineQuest
{
	name = "nomoney3",
	requirements = {MaxMoney(250), VarEquals("nomoney",2) },
	starter = "lender",
	forceOffer = true,
	gifts = {AwardMoney(3000)},
	goals = { RequireWeeks(4) , MinMoney(5000)},
	rewards ={ AwardMoney(-5000), IncrementVar("nomoney"),},
}

DefineQuest
{
	name = "nomoney4",
	requirements = {MaxMoney(250), VarMoreThan("nomoney",2) },
	repeatable = true,
	starter = "lender",
	forceOffer = true,
	gifts = {AwardMoney(3000)},
	goals = { RequireWeeks(4) , MinMoney(7500)},
	rewards ={ AwardMoney(-7500), IncrementVar("nomoney"),},
}

-- MISC QUESTS -----------------------------------------------------

DefineQuest
{
	name = "notoden",
	requirements = { MaxRank(3)},
	starter = "ny_gambler01b",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "welcometoden",
	requirements = {MinRank(4)},
	starter = "ny_gambler01",
	forceAccept = true,
	forceOffer = true,
--	repeatable = true,
}

-- PLOT QUESTS -----------------------------------------------------

DefineQuest
{
	name = "villain01_story01",
	requirements = {MinRank(1), MaxRank(1)},
	starter = "villain01",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain02_story01",
	requirements = {MinRank(1), MaxRank(1)},
	starter = "villain02",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain03_story01",
	requirements = {MinRank(1), MaxRank(1)},
	starter = "villain03",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain04_story01",
	requirements = {MinRank(1), MaxRank(1)},
	starter = "villain04",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain01_story02",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain01",
--	repeatable = true,
	forceAccept = true,
}


DefineQuest
{
	name = "villain03_story02",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain03",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain04_story02",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain04",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "lender_talk",
	requirements = {MinWeek(16), MaxRank(2), MaxMoney(499000)},
	starter = "lender",
	repeatable = true,
	forceAccept = true,
	rewrds = {DelayQuest("lender_talk", 75)},
	
}


DefineQuest
{
	name = "sf_bchq_angry",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "sf_bchqkeep",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_bchq_rank4_preover",
	requirements = {MinRank(4), MaxRank(4), VarLessThan("evilover",7)},
	starter = "sf_bchqkeep",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_bchq_rank4_evilover",
	requirements = {MinRank(4), MaxRank(4), VarEquals("evilover",7)},
	starter = "sf_bchqkeep",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank_2_story",
	requirements = {RequireQuest("rank2_mid"), MinRank(2), MaxRank(2)},
	starter = "sf_tutor",
	forceAccept = true,
}

DefineQuest
{
	name = "cas_shopkeep_rank2_story01",
	requirements = {MinRank(2)},
	starter = "cas_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "bcsign03_story",
	requirements = {VarEquals("bcsign", 3)},
	starter = "traveler14",
	forceAccept = true,
}


DefineQuest
{
	name = "bcsign04_story",
	requirements = {VarEquals("bcsign", 4)},
	starter = "traveler01",
	forceAccept = true,
}


DefineQuest
{
	name = "bcsign04_story02",
	requirements = {VarEquals("bcsign", 4)},
	starter = "sf_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank1",
	requirements = {MinRank(1), MaxRank(1), RequireQuest("novice01"), RequireQuest("novice02"),},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank2a",
	requirements = {MinRank(2), MaxRank(2), RequireQuestIncomplete("rank2_mid"),},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank2b",
	requirements = {MinRank(2), MaxRank(2),  RequireQuest("rank2_mid"),},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank3",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank4",
	requirements = {MinRank(4), MaxRank(4), VarLessThan("evilover", 3)},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("sf_tutor_rank4", 21)},
}

DefineQuest
{
	name = "factories_nudge",
	requirements = {MinRank(4), RequireQuestIncomplete("takeover_01"), RequireNoMedal("factory")},
	starter = "traveler16",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("factories_nudge", 100)},
}

DefineQuest
{
	name = "sftutor_rank2_story01",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "sf_tutor",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sftutor_rank2_lovestory01",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "sf_tutor",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank2_story01",
	requirements = {MinRank(2), MaxRank(4)},
	starter = "cay_hotelkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank2_story02",
	requirements = {MinRank(2), MaxRank(4)},
	starter = "cay_farmkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank2_story03",
	requirements = {MinRank(2), MaxRank(4)},
	starter = "cay_isleskeep",
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank2_story04",
	requirements = {MinRank(2), MaxRank(3), RequireBuilding("sj_shop")},
	starter = "sj_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank2_story05",
	requirements = {MinRank(2), MaxRank(3)},
	starter = "sj_farmkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "love_rank3_story01",
	requirements = {MinRank(3), MaxRank(4)},
	starter = "syd_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "sean_hello",
	requirements = {MinRank(2), MaxRank(4), RequireQuestIncomplete("ciaochristoph_03"), RequireQuestIncomplete("takeover_06b") },
	starter = "him_mountainkeep",
	rewards = {IncrementVar("knowsean")},
	forceAccept = true,
}

DefineQuest
{
	name = "sean_rank3_story01",
	requirements = {MinRank(3), MaxRank(4), RequireQuestIncomplete("ciaochristoph_03"), RequireQuestIncomplete("takeover_06b") },
	starter = "him_mountainkeep",
	rewards = {IncrementVar("knowsean")},
	forceAccept = true,
}

DefineQuest
{
	name = "expose_rank2_story01",
	requirements = {MinRank(2), VarLessThan("exposed", 1)},
	starter = "villain02",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank2_story02",
	requirements = {MinRank(2), VarLessThan("exposed", 2)},
	starter = "traveler05",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank2_story03",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "traveler01",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank2_story04",
	requirements = {MinRank(2), MaxRank(3)},
	starter = "traveler03",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank2_story05",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "traveler16",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank3_story01",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "traveler01",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank3_story02",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "traveler05",
	forceAccept = true,
	rewards = {IncrementVar("exposed")},
}

DefineQuest
{
	name = "expose_rank5_story01",
	requirements = {RequireQuest ("expose_rank3_story01"), MinRank(5)},
	starter = "traveler01",
	forceAccept = true,
}

DefineQuest
{
	name = "villain02_rank2_story01",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain02",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain03_rank2_story01",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain03",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("villain03_rank2_story01", 55)},
}

DefineQuest
{
	name = "villain03_rank2_story02",
	requirements = {MinRank(2), MaxRank(2)},
	starter = "villain03",
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("villain03_rank2_story02", 55)},
}

DefineQuest
{
	name = "villain04_rank3_story01",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "villain04",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain03_rank3_story01",
	requirements = {MinRank(3), MaxRank(3)},
	starter = "villain03",
--	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "villain04_warning",
	requirements = {MinRank(2), MaxRank(4)},
	starter = "traveler02",
	forceAccept = true,
}


DefineQuest
{
	name = "evilstuff01_rank3_01_leadin",
	requirements = {VarLessThan("evilover", 5), MinRank(3), MaxRank(4), RequireBuilding("ny_factory")},
	starter = "villain01",
	forceAccept = true,
	followUp = "evilstuff01_rank3_01",
}

DefineQuest
{
	name = "evilstuff01_rank3_01",
	requirements = {VarLessThan("evilover", 5), MinRank(3), RequireBuilding("ny_factory")},
	starter = "villain01",
	accept = "sure",
	reject = "dontthinkso",
	denial = {ShowDialog("evilstuff01_rank3_01_extra01"), MarkComplete("evilstuff01_rank3_01"), MarkComplete("evilstuff01_rank3_02"), IncrementVar("evilexp")}, 
	followUp = "evilstuff01_rank3_02",
}

DefineQuest
{
	name = "evilstuff01_rank3_02",
	requirements = {RequireQuest("evilstuff01_rank3_01"), VarLessThan("evilover", 5), MinRank(3), RequireBuilding("ny_factory")},
	starter = "villain01",
	forceAccept = true,
	ender = "announcer",
	goals = {RequireWeeks(3)},
	rewards = {AwardMessage("evilstuff01_rank3_02_msg"), StopFactory("ny_factory"), IncrementVar("evilexp")},
}


DefineQuest
{
	name = "evilstuff02_rank3_01",
	requirements = {VarLessThan("evilover", 5), MinRank(3), MaxRank(4), RequireQuest("villain04_warning"), RequireBuilding("pa_factory")},
	starter = "villain04",
	ender = "traveler13",
	denial = {ShowDialog("evilstuff02_rank3_01_extra01"), MarkComplete("evilstuff02_rank3_01"), IncrementVar("evilexp")}, 
	gifts = {ShowDialog("evilstuff02_rank3_01_extra02")},
	goals = {RequireWeeks(4)},
	rewards = {SetVar("evilstuff02_after", 1), AwardMessage("evilstuff02_rank3_01_msg"), StopFactory("pa_factory"), IncrementVar("evilexp")},
}

DefineQuest
{
	name = "evilstuff02_after",
	requirements = {VarEquals("evilstuff02_after", 1)},
	starter = "pa_factorykeep",
	forceAccept =true,
}

DefineQuest
{
	name = "evilstuff03_rank3",
	requirements = {VarLessThan("evilover", 5), MinRank(3), MaxRank(4), RequireItem("milk", 1)},
	starter = "traveler06",
	forceAccept = true,
	rewards = {AwardMessage("evilstuff03_rank3_msg"), ClearItem("milk"), IncrementVar("evilexp")},
}

DefineQuest
{
	name = "evilstuff04_rank3",
	requirements = {VarLessThan("evilover", 5), MinRank(3), MaxRank(4), VarMoreThan("evilexp",0), RequireItem("sugar", 1)},
	starter = "villain02",
	denial = {MarkComplete("evilstuff04_rank3"), IncrementVar("evilexp"), ShowDialog("evilstuff04_rank3_extra01"),}, 
	rewards = {AwardMessage("evilstuff03_rank3_msg"), ClearItem("sugar"), IncrementVar("evilexp")},
}

DefineQuest
{
	name = "ciaochristoph_01",
	requirements = {RequirePort("himalayas"), VarLessThan("evilover", 5), RequireRecipesKnown("exotic", 2), MinRank(4), VarMoreThan("exposed", 2), VarMoreThan("evilexp", 1)},
	starter = "traveler15",
	ender = "sf_tutor",
	summary = "backtoalex3",
	rewards = {IncrementVar("evilover")},
	forceAccept = true,
	followUp = "ciaochristoph_02",
}

DefineQuest
{
	name = "ciaochristoph_02",
	requirements = {VarLessThan("evilover", 5), RequireRecipesKnown("exotic", 3), MinRank(4), VarMoreThan("exposed", 2), VarMoreThan("evilexp", 1)},
	starter = "sf_tutor",
	ender = "syd_other2keep",
	forceAccept = true,
	rewards = {IncrementVar("evilover")},
	followUp = "ciaochristoph_03",
}

DefineQuest
{
	name = "ciaochristoph_03",
	requirements = {VarLessThan("evilover", 5), RequireRecipesKnown("exotic", 3), MinRank(4), VarMoreThan("exposed", 2), VarMoreThan("evilexp", 1)},
	starter = "syd_other2keep",
	ender = "him_mountainkeep",
	forceAccept = true,
	goals = {RequireItem("p_02", 100)},
	rewards = {IncrementVar("evilover"), AwardItem("p_02", - 100)},
	followUp = "ciaochristoph_end",
}

DefineQuest
{
	name = "ciaochristoph_end",
	requirements = {RequireRecipesKnown("exotic", 3), MinRank(4), VarMoreThan("exposed", 2), VarMoreThan("evilexp", 1)},
	starter = "him_mountainkeep",
	ender = "syd_other2keep",
	forceAccept = true,
	rewards = {SetHappy("sf_bchqkeep"), ShowDialog("ciaochristoph_end_extra01", "sf_bchqkeep"), SetVar("evilover", 7)},
}

DefineQuest
{
	name = "sf_bchq_rank5_gameover",
	requirements = {MinRank(5)},
	starter = "sf_bchqkeep",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "sf_tutor_rank5_gameover",
	requirements = {MinRank(5)},
	starter = "sf_tutor",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "syd_other2keep_rank5_gameover",
	requirements = {MinRank(5)},
	starter = "syd_other2keep",
	repeatable = true,
	forceAccept = true,
}

DefineQuest
{
	name = "keyfolks_rank5_gameover",
	requirements = {MinRank(5)},
	starter = {"traveler15", "traveler16", "cay_hotelkeep", "cay_farmkeep", "syd_shopkeep", "sj_farmkeep", "sj_shopkeep", "cay_isleskeep", "cas_shopkeep"},
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("keyfolks_rank5_gameover", 39)},
}

DefineQuest
{
	name = "evilfolks_rank5_gameover",
	requirements = {MinRank(5)},
	starter = {"villain01", "villain02", "villain03", "villain04"},
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("evilfolks_rank5_gameover", 39)},
}

DefineQuest
{
	name = "announcer_rank5_gameover",
	requirements = {MinRank(5)},
	starter = {"announcer"},
	repeatable = true,
	forceAccept = true,
	rewards = {DelayQuest("announcer_rank5_gameover", 59)},
}


DefineQuest
{
	name = "goldengate_hint01",
	requirements = {MinRank(2), MinWeek(303), MaxWeek(345)},
	starter = {"traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12",  "traveler13", "traveler14"},
	forceAccept = true,
}

DefineQuest
{
	name = "goldengate_const01",
	requirements = {MinRank(2), MinWeek(440), MaxWeek(540)},
	starter = { "traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06",},
	forceAccept = true,
--	priority = true,
}

DefineQuest
{
	name = "goldengate_const02",
	requirements = {MinRank(2), MinWeek(541), MaxWeek(636)},
	starter = {"traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12",  "traveler13", "traveler14"},
	forceAccept = true,
--	priority = true,
}

DefineQuest
{
	name = "goldengate_justdone01",
	requirements = {MinRank(2), MinWeek(637), MaxWeek(660)},
	starter = {"announcer", "talker", "lender", "gambler", "traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12",  "traveler13", "traveler14"},
	forceAccept = true,
	priority = true,
	rewards = {DelayQuest("goldengate_done01", 54)},
}

DefineQuest
{
	name = "goldengate_done01",
	requirements = {MinRank(2), MinWeek(660)},
	starter = {"announcer", "talker", "lender", "gambler", "traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler09", "traveler10", "traveler11", "traveler12",  "traveler13", "traveler14"},
--	repeatable = true,
	forceAccept = true,
--	rewards = {DelayQuest("goldengate_done01", 84)},
}

DefineQuest
{
	name = "empire_const01",
	requirements = {MinRank(2), MinWeek(222), MaxWeek(319)},
	starter = { "traveler01", "traveler02", "traveler03", "traveler04", "traveler05", "traveler06",},
	forceAccept = true,
--	priority = true,
}

DefineQuest
{
	name = "empire_justdone01",
	requirements = {MinRank(2), MinWeek(320), MaxWeek(340)},
	starter = {"traveler02", "traveler03", "traveler04", "traveler05", "traveler06", "traveler07", "traveler13", "traveler14"},
	forceAccept = true,
	priority = true,
	rewards = {DelayQuest("empire_done01", 44)},
}

DefineQuest
{
	name = "empire_done01",
	requirements = {MinRank(2), MinWeek(341)},
	starter = "ny_librarykeep",
	forceAccept = true,
}

DefineQuest
{
	name = "empire_done02",
	requirements = {MinRank(2), MinWeek(416), MaxWeek(950)},
	starter = "ny_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "chrysler_justdone01",
	requirements = {MinRank(2), MinWeek(262), MaxWeek(292)},
	starter = {"lender", "talker", "announcer", "traveler05", "traveler06", "traveler07", "traveler13", "traveler14"},
	forceAccept = true,
	priority = true,
	rewards = {DelayQuest("empire_done01", 44)},
}

DefineQuest
{
	name = "chrysler_done01",
	requirements = {MinRank(2), MinWeek(341)},
	starter = "ny_shopkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "flowers01",
	requirements = {MinRank(2), RequireItem("carnation",1)},
	starter = "sf_shopkeep",
	rewards = {AwardItem("carnation", -1), SetHappy("sf_shopkeep"), SetVar("HaggleBonus", 1)},
}

DefineQuest
{
	name = "flowers02",
	requirements = {MinRank(2), RequireItem("orchid",1)},
	starter = "ny_shopkeep",
	accept = "sure",
	rewards = {AwardItem("orchid", -1), RaiseMood("ny_shopkeep", 100), SetVar("HaggleBonus", 1)},
}

DefineQuest
{
	name = "flowers03",
	requirements = {MinRank(2), RequireItem("tulip",1)},
	starter = "ab_marketkeep",
	accept = "haveone",
	reject = "ohreally",
	rewards = {AwardItem("tulip", -1), RaiseMood("ab_marketkeep", 100), SetVar("HaggleBonus", 1)},
}

DefineQuest
{
	name = "flowers04_hint",
	requirements = {MinRank(2)},
	starter = "mos_barkeep",
	forceAccept = true,
}

DefineQuest
{
	name = "flowers04",
	requirements = {MinRank(2), RequireItem("orchid",1)},
	starter = "mos_shopkeep",
	accept = "haveone",
	reject = "justchance",
	rewards = {AwardItem("orchid", -1), RaiseMood("mos_shopkeep", 100), IncrementVar("HaggleBonus")},
}

DefineQuest
{
	name = "flowers05",
	requirements = {MinRank(2), RequireItem("rose",1)},
	starter = "pa_shopkeep",
	accept = "ofcourse",
	rewards = {AwardItem("rose", -1), RaiseMood("pa_shopkeep", 100), SetVar("HaggleBonus", 1)},
}

DefineQuest
{
	name = "flowers06_hint",
	requirements = {MinRank(2)},
	starter = "bom_other1keep",
	forceAccept = true,
}

DefineQuest
{
	name = "flowers06",
	requirements = {MinRank(2), RequireItem("rose",1)},
	starter = "bom_shopkeep",
	accept = "iwas",
	rewards = {AwardItem("rose", -1), RaiseMood("bom_shopkeep", 100), SetVar("HaggleBonus", 1)},
}

DefineQuest
{
	name = "flowers_tip",
	requirements = {MinRank(2)},
	starter = "him_palacekeep",
	forceAccept = true,
}

DefineQuest
{
	name = "ja_otherkeep_01",
	requirements = {MinRank(3)},
	starter = "ja_otherkeep",
	forceAccept = true,
}

--[[---------------------------------------------------------------------------


DefineQuest
{
	name = "lab02",
	requirements = { MinRank(2), MinMoney(155000)},
	starter = "ba_teatrokeep",
	goals = {MinMoney(150000)},
	rewards = {AwardMoney(-150000), AwardBuilding("ba_lab")},
}

	DelayQuest("rank4_lab_e_03_nudge", 65), DelayQuest("rank4_lab_e_04_nudge", 65), DelayQuest("rank4_lab_e_05_nudge", 65), DelayQuest("rank4_lab_e_06_nudge", 65),  DelayQuest("rank4_lab_e_07_nudge", 65), DelayQuest("rank4_lab_e_08_nudge", 65), DelayQuest("rank4_lab_e_09_nudge", 65),  DelayQuest("rank4_lab_e_10_nudge", 65), DelayQuest("rank4_lab_e_11_nudge", 65), DelayQuest("rank4_lab_e_12_nudge", 65),
	
]]---------------------------------------------------------------------------